/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.event;

import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.event.ClientFirstTickInWorldEvent;
import mcp.mobius.waila.api.event.IWailaEventListener;
import mcp.mobius.waila.api.event.WailaRegisterEvent;
import mcp.mobius.waila.api.event.WailaRenderEvent;
import mcp.mobius.waila.api.event.WailaTooltipEvent;

public final class WailaEventRegistrar {
    private static final List<IWailaEventListener> LISTENERS = new ArrayList<IWailaEventListener>();

    private WailaEventRegistrar() {
        throw new UnsupportedOperationException();
    }

    public static void register(IWailaEventListener listener) {
        LISTENERS.add(listener);
    }

    public static boolean postPreRender(WailaRenderEvent.Pre event) {
        for (IWailaEventListener listener : LISTENERS) {
            listener.onWailaRenderPre(event);
        }
        return event.isCancelled();
    }

    public static void postPostRender(WailaRenderEvent.Post event) {
        for (IWailaEventListener listener : LISTENERS) {
            listener.onWailaRenderPost(event);
        }
    }

    public static void postTooltip(WailaTooltipEvent event) {
        for (IWailaEventListener listener : LISTENERS) {
            listener.onWailaTooltip(event);
        }
    }

    public static boolean postPluginRegister(WailaRegisterEvent.Plugin event) {
        for (IWailaEventListener listener : LISTENERS) {
            listener.onWailaPluginRegister(event);
        }
        return event.isCancelled();
    }

    public static void postConfigRegister(WailaRegisterEvent.Config event) {
        for (IWailaEventListener listener : LISTENERS) {
            listener.onWailaConfigRegister(event);
        }
    }

    public static void postClientFirstTickInWorld(ClientFirstTickInWorldEvent event) {
        for (IWailaEventListener listener : LISTENERS) {
            listener.onClientFirstTickInWorld(event);
        }
    }
}

