/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import forge.Configuration;
import forge.Property;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcp.mobius.waila.addons.vanilla.HUDHandlerEntities;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.event.WailaEventRegistrar;
import mcp.mobius.waila.api.event.WailaRegisterEvent;
import mcp.mobius.waila.api.impl.ConfigModule;
import mcp.mobius.waila.overlay.OverlayConfig;
import mcp.mobius.waila.utils.FixDetector;

public class PluginConfig
implements IPluginConfig {
    private static PluginConfig _instance = null;
    private final Map<String, ConfigModule> modules = new LinkedHashMap<String, ConfigModule>();
    private final List<String> syncedConfigs = new ArrayList<String>();
    public Map<String, Boolean> forcedConfigs = new HashMap<String, Boolean>();
    public Configuration config = null;

    private PluginConfig() {
        _instance = this;
    }

    public static PluginConfig instance() {
        return _instance == null ? new PluginConfig() : _instance;
    }

    public ConfigModule addModule(String modName) {
        return this.addModule(modName, new ConfigModule(modName));
    }

    public ConfigModule addModule(String modName, ConfigModule options) {
        this.modules.put(modName, options);
        return options;
    }

    @Override
    public Set<String> getModuleNames() {
        return this.modules.keySet();
    }

    @Override
    public Map<String, String> getKeys(String modName) {
        return this.modules.containsKey(modName) ? this.modules.get((Object)modName).options : new HashMap<String, String>();
    }

    public void addConfig(String modName, String key, String translationKey) {
        this.addConfig(modName, key, translationKey, true);
    }

    public void addConfig(String modName, String key, String translationKey, boolean defValue) {
        this.addConfigInternal(modName, key, translationKey, defValue, false);
    }

    public void addSyncedConfig(String modName, String key, String translationKey) {
        this.addSyncedConfig(modName, key, translationKey, true);
    }

    public void addSyncedConfig(String modName, String key, String translationKey, boolean defValue) {
        this.addConfigInternal(modName, key, translationKey, defValue, true);
        this.syncedConfigs.add(key);
    }

    private void addConfigInternal(String modName, String key, String translationKey, boolean defValue, boolean synced) {
        WailaRegisterEvent.Config event = new WailaRegisterEvent.Config(modName, key, translationKey, defValue, synced);
        WailaEventRegistrar.postConfigRegister(event);
        this.config.getOrCreateBooleanProperty(key, "modules", event.getDefaultValue());
        this.config.save();
        if (!this.modules.containsKey(modName)) {
            this.addModule(modName);
        }
        this.modules.get(modName).addOption(key, translationKey);
    }

    @Override
    public boolean get(String key) {
        return this.get(key, true);
    }

    @Override
    public boolean get(String key, boolean defvalue) {
        if (this.syncedConfigs.contains(key) && !mod_BlockHelper.INSTANCE.serverPresent) {
            return false;
        }
        if (mod_BlockHelper.INSTANCE.serverPresent && this.forcedConfigs.containsKey(key)) {
            return this.forcedConfigs.get(key);
        }
        Property prop = this.config.getOrCreateBooleanProperty(key, "modules", defvalue);
        return prop.getBoolean(defvalue);
    }

    @Override
    public boolean set(String key, boolean value) {
        if (this.syncedConfigs.contains(key) && !mod_BlockHelper.INSTANCE.serverPresent) {
            return false;
        }
        if (mod_BlockHelper.INSTANCE.serverPresent && this.forcedConfigs.containsKey(key)) {
            return false;
        }
        Property prop = this.config.getOrCreateBooleanProperty(key, "modules", value);
        prop.value = Boolean.toString(value);
        this.config.save();
        return true;
    }

    public boolean isSyncedConfig(String key) {
        return this.syncedConfigs.contains(key);
    }

    public boolean get(String category, String key, boolean default_) {
        Property prop = this.config.getOrCreateBooleanProperty(key, category, default_);
        return prop.getBoolean(default_);
    }

    public void setConfig(String category, String key, boolean state) {
        this.config.getOrCreateBooleanProperty((String)key, (String)category, (boolean)state).value = String.valueOf(state);
        this.config.save();
    }

    public int get(String category, String key, int default_) {
        Property prop = this.config.getOrCreateIntProperty(key, category, default_);
        return prop.getInt();
    }

    public void setConfig(String category, String key, int state) {
        this.config.getOrCreateIntProperty((String)key, (String)category, (int)state).value = String.valueOf(state);
        this.config.save();
    }

    public boolean showTooltip() {
        return this.get("general", "waila.cfg.show", true);
    }

    public boolean showIcon() {
        return this.get("general", "waila.cfg.showicon", true);
    }

    public void loadDefaultConfig(Configuration cfg) {
        this.config = cfg;
        this.config.load();
        this.get("general", "waila.cfg.show", true);
        this.get("general", "waila.cfg.showmode", true);
        this.get("general", "waila.cfg.liquid", false);
        this.get("general", "waila.cfg.metadata", true);
        this.get("general", "waila.cfg.keybind", true);
        this.get("general", "waila.cfg.showicon", true);
        OverlayConfig.posX = this.get("general", "waila.cfg.posx", 5000);
        OverlayConfig.posY = this.get("general", "waila.cfg.posy", 100);
        OverlayConfig.scale = (float)this.get("general", "waila.cfg.scale", 100) / 100.0f;
        OverlayConfig.alpha = this.get("general", "waila.cfg.alpha", 80);
        OverlayConfig.bgcolor = this.get("general", "waila.cfg.bgcolor", 0x100010);
        OverlayConfig.gradient1 = this.get("general", "waila.cfg.gradient1", 0x5000FF);
        OverlayConfig.gradient2 = this.get("general", "waila.cfg.gradient2", 2621567);
        OverlayConfig.fontcolor = this.get("general", "waila.cfg.fontcolor", 0xA0A0A0);
        HUDHandlerEntities.nhearts = this.get("general", "waila.cfg.heartsperline", 20);
        HUDHandlerEntities.maxhpfortext = this.get("general", "waila.cfg.maxhpbeforetext", 40);
        mod_BlockHelper.UPDATER.notify = this.get("general", "waila.cfg.updatecheck", true);
        FixDetector.notify = this.get("general", "waila.cfg.fixernotify", true);
        mod_BlockHelper.DEV_MODE = this.get("general", "waila.cfg.devmode", false);
        this.get("general", "waila.cfg.hideindebug", true);
        int iconAlign = this.get("general", "waila.cfg.iconalign", 1);
        if (iconAlign < 0 || iconAlign > 2) {
            this.setConfig("general", "waila.cfg.iconalign", 1);
        }
        this.config.save();
    }
}

